<?php
// Kļūdu diagnostika (ļoti svarīgi attīstības laikā)
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();

// Savienojuma iestatījumi
$servername = "109.106.254.1";  
$username = "u353443769_beis";  
$password = 'Te$t@dm1n';        
$dbname = "u353443769_beis";    

// Izveido savienojumu ar datubāzi
$conn = new mysqli($servername, $username, $password, $dbname);

// Pārbauda savienojuma statusu
if ($conn->connect_error) {
    die("Savienojuma kļūda: " . $conn->connect_error);
}

// Mainīgais reģistrācijas kļūdām
$error_message = "";

// Pārbauda, vai forma ir iesniegta
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Iegūst formā ievadītos datus
    $username = trim($_POST['username']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];

    // Pārbauda, vai paroles sakrīt
    if ($password !== $confirm_password) {
        $error_message = "Paroles nesakrīt! Lūdzu, mēģini vēlreiz.";
    } else {
        // Šifrē paroli (hashēšana ar PASSWORD_BCRYPT)
        $hashed_password = password_hash($password, PASSWORD_BCRYPT);

        // Pārbauda, vai lietotājvārds vai e-pasts jau eksistē
        $query = "SELECT * FROM dn_auto_users WHERE username = ? OR email = ?";
        $stmt = $conn->prepare($query);

        if (!$stmt) {
            die("Kļūda vaicājuma sagatavošanā: " . $conn->error);
        }

        $stmt->bind_param("ss", $username, $email);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $error_message = "Lietotājvārds vai e-pasts jau eksistē! Lūdzu, izvēlieties citu.";
        } else {
            // Ja viss ir kārtībā, ievieto lietotāju datubāzē
            $insertQuery = "INSERT INTO dn_auto_users (username, email, password) VALUES (?, ?, ?)";
            $insertStmt = $conn->prepare($insertQuery);

            if (!$insertStmt) {
                die("Kļūda sagatavojot ievietošanas vaicājumu: " . $conn->error);
            }

            $insertStmt->bind_param("sss", $username, $email, $hashed_password);

            if ($insertStmt->execute()) {
                echo "<p class='success-message'>Reģistrācija veiksmīga! Vari pieslēgties.</p>";
            } else {
                $error_message = "Kļūda reģistrācijas laikā: " . $insertStmt->error;
            }

            // Aizver vaicājumus un savienojumu
            $insertStmt->close();
        }
    }

    // Aizver vaicājumu un savienojumu
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Daniils Lubimcevs">
    <meta name="create date" content="29.11.2024">
    <title>DaniilsAuto.lv - Reģistrācija</title>
    <link rel="stylesheet" href="css/register.css"> <!-- Atsevišķais stils -->
    <script src="js/index.js"></script>
    <script src="js/script.js"></script>
</head>
<body>
    <!-- Topbars no menu.php -->
    <?php include('menu.php'); ?>

    <header>
        <h1>Reģistrēties</h1>
    </header>

    <div class="container">
        <!-- Paziņojums par kļūdām -->
        <?php if ($error_message): ?>
            <div class="error-message"><?php echo $error_message; ?></div>
        <?php endif; ?>

        <form action="register.php" method="POST">
            <label for="username">Lietotājvārds:</label>
            <input type="text" id="username" name="username" required><br><br>

            <label for="email">E-pasts:</label>
            <input type="email" id="email" name="email" required><br><br>

            <label for="password">Parole:</label>
            <input type="password" id="password" name="password" required><br><br>

            <label for="confirm_password">Apstiprināt paroli:</label>
            <input type="password" id="confirm_password" name="confirm_password" required><br><br>

            <button type="submit">Reģistrēties</button>
        </form>
    </div>

    <footer>
        <p>&copy; 2024 Daniils Lubimcevs. Visas tiesības aizsargātas.</p>
    </footer>
</body>
</html>
